/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.client.render;

import com.hollingsworth.ars_creo.common.block.StarbuncleWheelBlock;
import com.hollingsworth.ars_creo.common.block.StarbuncleWheelTile;
import com.hollingsworth.ars_creo.common.registry.ModBlockRegistry;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.processor.IBone;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;

public class CarbuncleWheelModel
extends AnimatedGeoModel<StarbuncleWheelTile> {
    public void setLivingAnimations(StarbuncleWheelTile entity, Integer uniqueID) {
        super.setLivingAnimations((Object)entity, uniqueID);
    }

    public void setLivingAnimations(StarbuncleWheelTile entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("wheel");
        Direction facing = (Direction)entity.m_58900_().m_61143_((Property)StarbuncleWheelBlock.FACING);
        float angle = CarbuncleWheelModel.getAngleForTe((KineticTileEntity)entity, entity.m_58899_(), ModBlockRegistry.STARBY_WHEEL.getRotationAxis(entity.m_58900_()));
        if (facing == Direction.SOUTH || facing == Direction.EAST) {
            angle = -angle;
        }
        head.setRotationY(angle);
    }

    public static float getAngleForTe(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        float offset = CarbuncleWheelModel.getRotationOffsetForPosition(te, pos, axis);
        return (time * te.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
    }

    protected static float getRotationOffsetForPosition(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float offset = ICogWheel.isLargeCog((BlockState)te.m_58900_()) ? 11.25f : 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.m_123341_()) + (axis == Direction.Axis.Y ? 0 : pos.m_123342_()) + (axis == Direction.Axis.Z ? 0 : pos.m_123343_())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }

    public ResourceLocation getModelLocation(StarbuncleWheelTile object) {
        return new ResourceLocation("ars_creo", "geo/starbuncle_wheel.geo.json");
    }

    public ResourceLocation getTextureLocation(StarbuncleWheelTile object) {
        return new ResourceLocation("ars_creo", "textures/blocks/starbuncle_wheel.png");
    }

    public ResourceLocation getAnimationFileLocation(StarbuncleWheelTile animatable) {
        return new ResourceLocation("ars_creo", "animations/starbuncle_wheel_animation.json");
    }
}

